% LM01-48x240
[D
	/Caption 'LM01-48x240'
	/Type 'Actuator Definition File'
	/Version 25
	/MinMCSubVersionR6 0		% This File requires MS SW Parameter Tree Version 6.0 or higher  (for release 6 firmware)
	
	%************************************************************************************************* 	
	
	% WIZARD PAGES BEGIN   
	/WizardPages [A
		[D	
			/PageID		14			%Actuator Selection
			/PageInfo	[A 
				[D /Name 'GuideUnit_Name' /CapitalLetters #1]
				[D /Name 'GuideUnit_ArtNr' /Tabs 1 /Visible 'Not_On_Error' ] 	 	 		
				[D /Name 'GuideUnit_NominalStroke' /Tabs 1 /Visible 'Not_On_Error' ]	
				[D /Name 'Stator_Name' /CapitalLetters #1 ]     
				[D /Name 'Stator_ArtNr' /Tabs 1 /Visible 'Not_On_Error' ]	 
				[D /Name 'Slider_Name' /CapitalLetters #1	/Visible 'Not_On_Error' ]
				[D /Name 'Slider_ArtNr' /Tabs 1	/Visible 'Not_On_Error']	    	
				[D /Name 'Slider_Length' /Tabs 1	/Visible 'Not_On_Error']	    	
				[D /Name 'Slider_Direction' /Tabs 1	/Visible 'Not_On_Error']
				[D /Name 'Motor_Name' /CapitalLetters #1 /Visible 'Not_On_Error' ]
				[D /Name 'Force_Constant' /Tabs 1 /Visible 'Not_On_Error' ]
				[D /Name 'Cooling' /Tabs 1 ]	    	
			]
		]
		[D	
			/PageID		19			%Controller Settings
			/PageInfo	[A  	  	
			]
		]		
		[D	
			/PageID		2			%Extension Cable Setup
			/PageInfo	[A  	  	
				[D /Name 'Coil_Resistance' ]	
				[D /Name 'Ext_Cable_Resistance'   ]
				[D /Name 'Total_Resistance' ]
			]
		]
		[D	
			/PageID		3			%External Position Sensor System			
			/VisibleIfParsExisting [A
				'ExtSensor_Type'	
			]
			/PageInfo	[A
			]	
		]
		[D	
			/PageID		15			%Feed Forward Parameters for Linear Modules
			/PageInfo	[A  
				[D /Name 'TotalMoved_Mass' ]      	     	
				[D /Name 'GravitaionForce' /Tabs 1]
				[D /Name 'SignedExtConstForce' /Tabs 1]
				[D /Name 'SumOfConstForces' ]
				[D /Name 'FF_ConstForce_SetA' ]
				[D /Name 'FF_Friction_SetA']
				[D /Name 'FF_Damping_SetA']
				[D /Name 'FF_Acceleration_SetA' ]
			]	  		
		]
		[D	
			/PageID		5			%PID Position Controller
			/PageInfo	[A  
				[D /Name 'P_Gain_SetA' ]    
				[D /Name 'D_Gain_SetA' ]    
				[D /Name 'I_Gain_SetA' ]    
				[D /Name 'IntegratorLimit_SetA' ]    
				[D /Name 'MaxCurrent_SetA' ]    
				[D /Name 'NoiseDeadBandSetA' ]	     	
			]		
		]
		[D	
			/PageID		16			%Homing
			/PageInfo	[A  
				[D  /Name 'Home_Mode' /Visible 'Only_On_Error' ]			     	
				[D  /Name 'HomeConf_SliderHomePosition' /Visible 'Not_On_Error' ]		
				[D	/Name 'HomeConf_HomePosition' /Visible 'Not_On_Error' ]
				[D  /Name 'InitialPosConf_Position'  /Visible 'Not_On_Error' ] 	 
			]
		]
	]	
	
	% WIZARD VALUES BEGIN
	/WizardValues [A      
		[D
			/Name 'Actuator_Type'
			/Caption 'Actuator Type'
			/Type 'INTEGER'
			/Value 5 
		]	   			
		[D 
			/Name 'Module_Name'
			/Caption 'Module Name'	
			/Type 'STRING'
			/Value ''
			/ShowWithCompanyPrefix #1					  		 
		]
		[D 
			/Name 'Module_Base_Name'
			/Caption 'Module Base Name'	
			/Type 'STRING'
		]
		[D 
			/Name 'Module_Name_Extension'
			/Caption 'Module Name Extension'	
			/Type 'STRING'
		] 	
		[D 
			/Name 'GuideUnit_Name'
			/CaptionKeyWord 'Guide_Unit'	
			/Type 'STRING'
			/Value ''
			/ShowWithCompanyPrefix #1					  		 
		]
		[D 
			/Name 'GuideUnit_ArtNr'
			/CaptionKeyWord 'Article_Number'	
			/Type 'STRING'
			/Value ''
			/ShowWithCompanyPrefix #1					  		 
		]	 	
		[D 
			/Name 'GuideUnit_NominalStroke'
			/CaptionKeyWord 'Stroke'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D 
			/Name 'GuideUnit_SliderMass'
			/Caption 'Guide Unit Mass'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D 
			/Name 'GuideUnit_StatorMass'
			/Caption 'Guide Unit Mass'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D 
			/Name 'GuideUnit_SliderHomePosNegative'
			/Caption 'Slider Home Position'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D 
			/Name 'GuideUnit_SliderHomeGapNegative'
			/Caption 'Home Gap'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D 
			/Name 'GuideUnit_SliderHomePosPositive'
			/Caption 'Slider Home Position'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D 
			/Name 'GuideUnit_SliderHomeGapPositive'
			/Caption 'Home Gap'	
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D
			/Name 'Motor_PreName'
			/Caption 'Motor'
			/Type 'STRING'
			/Value '' 
		]	   	
		[D
			/Name 'Motor_Name'
			/ShowWithCompanyPrefix #1					 
			/CaptionKeyWord 'Motor'
			/Type 'STRING'
			/Value '' 
		]	   	   	
		[D
			/Name 'Motor_Name_Extension'
			/Caption 'Motor Name Extension'
			/Type 'STRING'
			/Value '' 
		]	   	   	   	
		[D
			/Name 'Motor_Name_SD_Extension'
			/Caption 'Motor Name Slider Extension'
			/Type 'STRING'
			/Value '' 
		]	   	   	   	   	   	   	
		[D
			/Name 'Stator_Name'
			/CaptionKeyWord 'Stator'
			/ShowWithCompanyPrefix #1					
			/Type 'STRING'
			/Value '' 
		]	   	
		[D
			/Name 'Slider_Name'
			/CaptionKeyWord 'Slider'
			/ShowWithCompanyPrefix #1					
			/Type 'STRING'
			/Value '' 
		]	   	
		[D
			/Name 'Stator_Length'
			/CaptionKeyWord 'Stator_Length'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D
			/Name 'Complete_Stator_Length'
			/CaptionKeyWord 'Stator_Length'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D
			/Name 'Complete_Stator_EndPieceLength'
			/Caption 'Stator End Piece Length'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   		   	
		[D
			/Name 'Complete_Stator_Mass'
			/CaptionKeyWord 'Stator_Mass'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 8
		]	   		   	
		[D
			/Name 'Stator_ActiveLength'
			/Caption 'Stator Active Length'
			/Type 'DOUBLE'
			/Value 0.24 
			/UUID 5
		]	   		   	
		[D
			/Name 'Stator_ArtNr'
			/CaptionKeyWord 'Article_Number'
			/ShowWithCompanyPrefix #1					
			/Type 'STRING'
			/Value '' 
		]	   	
		[D
			/Name 'Stator_EndPieceLength'
			/Caption 'Stator End Piece Length'
			/Type 'DOUBLE'
			/Value 0.006
			/UUID 5
		]	   		   	
		[D
			/Name 'Stator_Mass'
			/CaptionKeyWord 'Stator_Mass'
			/Type 'DOUBLE'
			/Value 0.0
			/UUID 8
		]	   		   	
		[D
			/Name 'Stator_SensorLength'
			/Caption 'Stator Sensor Length'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   		   	
		[D
			/Name 'Slider_Length'
			/CaptionKeyWord 'Slider_Length'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D
			/Name 'Slider_ActiveLength'
			/Caption 'Slider Active Length'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   		   	
		[D
			/Name 'Slider_ArtNr'
			/CaptionKeyWord 'Article_Number'
			/ShowWithCompanyPrefix #1					
			/Type 'STRING'
			/Value '' 
		]
		[D
			/Name 'RelativeEdgeForce'
			/CaptionKeyWord 'EdgeForce'
			/Type 'Double'
			/Value 0.0
			/UUID 1
		]	   		   	
		[D
			/Name 'Coil_TempCoeff'
			/Caption 'Coil Temperature Coefficent'
			/Type 'DOUBLE'
			/Value 0.0039  
			/UUID 0
		]	   		   	
		[D
			/Name 'Slider_Mass'
			/CaptionKeyWord 'Slider_Mass'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 8
		]	   		   	
		[D
			/Name 'Slider_EndPieceLength'
			/Caption 'Slider End Piece Length'
			/Type 'DOUBLE'
			/Value 0.01 
			/UUID 5
		]	   		   	
		[D
			/Name 'Slider_PolePitch'
			/Caption 'Slider Pole Pitch'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   		   	
		[D
			/Name 'Motor_FactorPerPolePitch'
			/Caption 'Motor Factor Per Pole Pitch'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 0
		]	   		   	
		[D
			/Name 'Total_Resistance'
			/CaptionKeyWord 'Total_Resistance'
			/Type 'Double'
			/Value 0.0
			/UUID 15
		]	   		   	      
		[D
			/Name 'TotalMoved_Motor_Mass'
			/Caption 'Total Moved Motor Mass'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 8
		]
		[D 
			/Name 'SignedExtConstForce' 
			/CaptionKeyWord 'Constant_Force'
			/Type 'DOUBLE'
			/Value 0.0
			/UUID 9		
		]
		[D 
			/Name 'GravitaionForce' 
			/CaptionKeyWord 'MotorGravitationForce'
			/Type 'DOUBLE'
			/Value 0.0
			/UUID 9		
		]
		[D 
			/Name 'SumOfConstForces' 
			/CaptionKeyWord 'Sum_of_Constant_Forces'
			/Type 'DOUBLE'
			/Value 0.0
			/UUID 9		
		]   
		[D
			/Name 'TotalMoved_Mass'
			/CaptionKeyWord 'Total_Moving_Mass'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 8
		]
		[D
			/Name 'P_GainSoft'
			/Caption 'Default P Gain'
			/Type 'DOUBLE'
			/Value 2000.0 
			/UUID 18
		]
		[D
			/Name 'D_GainSoft'
			/Caption 'Default D Gain'
			/Type 'DOUBLE'
			/Value 3.0 
			/UUID 19
		]
		[D
			/Name 'I_GainSoft'
			/Caption 'Default I Gain'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 20
		]
		[D
			/Name 'P_GainStiff'
			/Caption 'Default P Gain Stiff'
			/Type 'DOUBLE'
			/Value 5000.0 
			/UUID 18
		]
		[D
			/Name 'D_GainStiff'
			/Caption 'Default D Gain Stiff'
			/Type 'DOUBLE'
			/Value 7.5 
			/UUID 19
		]
		[D
			/Name 'I_GainStiff'
			/Caption 'Default I Gain Stiff'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 20
		]
		% EXTENSION CABLE
		[D
			/Name 'Cable1_Resistivity'
			/Caption 'Cable1 Resistivity'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 39
		]	   		   	
		[D
			/Name 'Cable2_Resistivity'
			/Caption 'Cable2 Resistivity'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 39   		
		]	   		   	
		[D
			/Name 'Cable1_Resistivity_Gen'
			/Caption 'Cable1 Resistivity Generic'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 39
		]	   		   	
		[D
			/Name 'Cable2_Resistivity_Gen'
			/Caption 'Cable2 Resistivity Generic'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 39   		
		]	   		   	
		% Homing
		[D
			/Name 'DistanceA'
			/CaptionKeyWord 'Distance_A'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
			/OnChange [A 
				[D /Name 'SetDistanceA' ]				
			]  		
		]	   	
		[D
			/Name 'DistanceB'
			/CaptionKeyWord 'Distance_B'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5   		
			/OnChange [A 
				[D /Name 'SetDistanceB' ]				
			]  		   		
		]	   	
		[D
			/Name 'DistanceC'
			/CaptionKeyWord 'Distance_C'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5
		]	   	
		[D
			/Name 'DistanceD'
			/CaptionKeyWord 'Distance_D'
			/Type 'DOUBLE'
			/Value 0.0 
			/UUID 5   		
		]	   	
	]
	
	% WIZARD VALUES END
	
	%************************************************************************************************* 	
	% MC PARAMETERS BEGIN   
	/MCParameters [A
		[D              	   	   
			/Name 'PlugAndPlay'   	
			/TreeUPID 112
			/StartWithTreeValue #1
			/Type 'ENUM'
			/OnChange [A  ]
			/ENumDef [A
				[D
					/Value 0
					/OnSelect [A	]								
				]																											
				[D
					/Value 1
					/OnSelect [A	]								
				]																											
				[D
					/Value 2
					/OnSelect [A	]								
				]																											
			]																		   		 	   	
		]
		[D
			/Name 'StatorInfoBlock_ArtNr'
			/TreeUPID 6276
			/Type 'ENUM'
		]
		[D
			/Name 'Phase_Switch_On_Test_Low_Level'
			/TreeUPID 4140
			/Type 'DOUBLE'
		]
		[D
			/Name 'Phase_Switch_On_Test_High_Level'
			/TreeUPID 4141
			/Type 'DOUBLE'
		]
		[D
			/Name 'Phase_Switch_On_Test_Max_InCurrent'
			/TreeUPID 4142
			/Type 'DOUBLE'
		]
		[D              	   	   
			/Name 'Motor_Type'   	
			/TreeUPID 4500
			/Type 'ENUM'
			/DefValue 2
			/OnChange [A  ]
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'No Motor'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 1
					%/Caption 'Generic'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 2
					%/Caption 'P01'					
					/OnSelect [A	]								
				]																											
			]																		   		 	   	
		]
		[D
			/Name 'ADF_Name'
			/TreeUPID 6220 
			/Type 'STRING'
			/DefValue 'BM01-48x240'
		]   	
		[D
			/Name 'MDF_Name'
			/TreeUPID 6255 
			/Type 'STRING'
		]   	
		[D
			/Name 'Stator_Type_Code'
			/TreeUPID 4613 
			/Type 'Enum'
			/DefValue -1
			/OnChange [A  
				[D	/Name 'CalculateMotorProperty']				
				[D /Name 'CalculateFFValues' ]
				[D /Name 'CalculateStrokeRange' ]				
				[D /Name 'Module_BuildActuatorName' ]	
			]
			/ENumDef [A
				[D
					/Value 8
					/Caption 'Stator Family PS01-48x240'					
					/OnSelect [A	
						[D /Name 'Motor_PreName' /Value 'P01-48x240@/' ]					
						[D /Name 'Coil_Resistance' /Value 3.0]
						[D /Name 'Coil_Inductivity' /Value 0.003 ] 	  
						[D /Name 'Maximal_Current' /Value 15.0]
						[D /Name 'Motor_FactorPerPolePitch' /Value 4.225 ]
						[D /Name 'CrossCoupling_PH1_Sine'	/Value -0.0105 ]
						[D /Name 'CrossCoupling_PH1_Cosine'	/Value -0.0005 ]
						[D /Name 'CrossCoupling_PH2_Sine'	/Value 0.0 ]
						[D /Name 'CrossCoupling_PH2_Cosine'	/Value 0.011 ]
						[D /Name 'HomeConf_CurrentLimit' /Value 50.0 ]
						[D /Name 'Com_BackEMFCalcSource' /Value 0 ]					  		
						[D /Name 'Module_Base_Name' /Value 'LM01-48x240' ]					
					]								
				]																											
				[D
					/Value 9
					/Caption 'Stator Family PS01-48x240F'					
					/OnSelect [A	
						[D /Name 'Motor_PreName' /Value 'P01-48x240F@/' ]					
						[D /Name 'Coil_Resistance' /Value 0.95]
						[D /Name 'Coil_Inductivity' /Value 0.0011 ] 	  
						[D /Name 'Maximal_Current' /Value 25.0 ] 
						[D /Name 'Motor_FactorPerPolePitch' /Value 2.383 ]
						[D /Name 'CrossCoupling_PH1_Sine'	/Value -0.0055 ]
						[D /Name 'CrossCoupling_PH1_Cosine'	/Value 0.0 ]
						[D /Name 'CrossCoupling_PH2_Sine'	/Value 0.0 ]
						[D /Name 'CrossCoupling_PH2_Cosine'	/Value 0.0055 ]
						[D /Name 'HomeConf_CurrentLimit' /Value 50.0 ]	
						[D /Name 'Com_BackEMFCalcSource' /Value 1 ]			%Velocity of X3 Feedback (only for 48x240F, since 3.5)		  		
						[D /Name 'Module_Base_Name' /Value 'LM01-48x240F' ]					
					]								
				]																											   		
			]
		]   	
		[D
			/Name 'Coil_Resistance'
			/CaptionKeyWord 'Phase_Resistance'
			/TreeUPID 4511 
			/Type 'DOUBLE'
		]
		[D
			/Name 'Coil_Resistance_Definition_Temp'
			/TreeUPID 4619 
			/Type 'DOUBLE'
		]   	   	
		[D
			/Name 'Coil_Inductivity'
			/TreeUPID 4512 
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Force_Constant'
			/CaptionKeyWord 'Force_Constant'   		
			/TreeUPID 4513 
			/Type 'DOUBLE'
		]
		[D
			/Name 'EdgeForce_Constant'
			/CaptionKeyWord 'EdgeForce_Constant'
			/TreeUPID 4517 
			/Type 'DOUBLE'
		]
		[D
			/Name 'Zero_Position'
			/CaptionKeyWord 'Zero_Position'
			/TreeUPID 4514 
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Shortened_Stroke'
			/CaptionKeyWord 'Shortened_Stroke'  		
			/TreeUPID 4515 
			/Type 'DOUBLE'
		]
		[D
			/Name 'Maximal_Stroke'
			/CaptionKeyWord 'Maximal_Stroke'
			/TreeUPID 4516 
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Maximal_Current'
			/TreeUPID 4510 
			/Type 'DOUBLE'
			/OnChange [A
				[D /Name 'CalculateControlParameters' ]
			]	
		]	   		   	
		[D
			/Name 'Maximal_Motor_Supply_Voltage'
			/TreeUPID 4519
			/Type 'DOUBLE'
		]	   		   	
		
		% FEEDBACK SELECTION BEGIN
		[D
			/Name 'Feedback_Selection'
			/TreeUPID 5010
			/Type 'ENUM'
			/StartWithTreeValue #1
			/OnChange [A ]  
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Feedback on X3 Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Feedback on X12 Sensor'					
					/OnSelect [A ]
				]																											
			]	
		]      	   		   		   	  	      	   	
		[D
			/Name 'Double_Feedback_Check'
			/TreeUPID 4711 
			/Type 'ENum'
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Disable'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Enable'					
					/OnSelect [A ]
				]																											
			] 	   		   		   	
		]	   		   	
		[D
			/Name  'Maximal_Feedback_Difference'
			/TreeUPID 4710
			/Type 'DOUBLE'
		]
		% FEEDBACK SELECTION END   	
		
		% MOTOR SENSOR CONFIGURATION BEGIN
		[D
			/Name 'MotSen_Type'
			/TreeUPID 4570
			/Type 'ENum'
			/DefValue 2
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'No Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Incremental AB encoder'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Sine/Cosine sensor'					
					/OnSelect [A 
						[D /Name 'PosRec_PositionTolerance' /Value 0.015 ]
					]
				]																											
				[D
					/Value 3
					%/Caption 'Absolut sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 4
					%/Caption 'Analog Absolut 0..5V'					
					/OnSelect [A ]
				]																											   		
			] 	   		   		   	
		]	   		   	   	
		[D
			/Name 'MotSen_Count_Direction'
			/TreeUPID 4571
			/Type 'ENum'
			/DefValue 1
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'Positive'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Negative'					
					/OnSelect [A ]
				]																											
			] 	   		   		   	
		]	   		   	
		[D
			/Name 'MotSen_WaveForm_Table'
			/TreeUPID 4520 
			/Type 'ENum'
			/DefValue 1
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		
			] 	   		   		   	
		]	   		   	
		[D
			/Name 'MotSen_FFT_C1'
			/TreeUPID 4521
			/Type 'DOUBLE'
			/DefValue 0.9152  		   		   	
		]	   		   	
		[D
			/Name 'MotSen_FFT_C3'
			/TreeUPID 4522
			/Type 'DOUBLE'
			/DefValue -0.0725 		   		   	
		]	   		   	
		[D
			/Name 'MotSen_FFT_C5'
			/TreeUPID 4523
			/Type 'DOUBLE'
			/DefValue 0.0005   		   		   	
		]	   		   	
		[D
			/Name 'MotSen_FFT_C7'
			/TreeUPID 4524
			/Type 'DOUBLE'
			/DefValue 0.0019   		   		   	
		]	   		   	
		[D
			/Name 'MotSen_FFT_C9'
			/TreeUPID 4525
			/Type 'DOUBLE'
			/DefValue -0.0006   		   		   	
		]	   		   	
		[D
			/Name 'ArcTan_Table'
			/TreeUPID 4529
			/Type 'ENum'
			/DefValue 0
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'Calculated'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2048
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   		
			] 	   		   		   	
		]	   		   	
		[D
			/Name 'MotSen_Resolution'
			/TreeUPID 4572
			/Type 'DOUBLE'
			/DefValue 0.015	   		   		   	
		]	   		   	
		[D
			/Name 'MotSen_SignalOffsetSine'
			/TreeUPID 4573
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'MotSen_SignalOffsetCosine'
			/TreeUPID 4574
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'MotSen_Relative_Cos_Gain'
			/TreeUPID 4579
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'MotSen_Hall_Distance_Err'
			/TreeUPID 4575
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'MotSen_SpeedFilterTime'
			/TreeUPID 4578
			/Type 'DOUBLE'
		]	   		   	
		% CROSS COUPLING
		[D
			/Name 'CrossCoupling_PH1_Sine'
			/TreeUPID 4580
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'CrossCoupling_PH1_Cosine'
			/TreeUPID 4581
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'CrossCoupling_PH2_Sine'
			/TreeUPID 4582
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'CrossCoupling_PH2_Cosine'
			/TreeUPID 4583
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'CrossCopling_SignalDelayTime'
			/TreeUPID 4755
			/Type 'DOUBLE'
		]	   		   	
		% MOTOR SENSOR CONFIGURATION END
		
		% MOTOR HALL SIGNAL BEGIN
		[D
			/Name 'Slider_Missing_Level'
			/TreeUPID 4640
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Hall_Signal_Missing_Level'
			/TreeUPID 4641
			/Type 'DOUBLE'
		]	   		   	
		% MOTOR HALL SIGNAL END
		
		% EXTERNAL SENSOR CONFIGURATION BEGIN
		[D
			/Name 'ExtSensor_Type'
			/TreeUPID 4700
			/Type 'ENUM'
			/StartWithTreeValue #1
			/OnChange [A
				[D /Name 'ChangeExtSensorType' ]				 
			]  
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Sensor'					
					/OnSelect [A
						[D /Name 'Feedback_Selection' /Value 0 ]					  
						[D /Name 'Double_Feedback_Check' /Value 0 ]					  
						[D /Name 'Com_BackEMFCalcSource' /Value 0 ]					  
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Incremental_AB'					
					/OnSelect [A	
						[D /Name 'Feedback_Selection' /Value 1 ]					  
						[D /Name 'Double_Feedback_Check' /Value 1 ]					  
						[D /Name 'Com_BackEMFCalcSource' /Value 2 ]					  						
					]
				]																											
				[D
					/Value 4
					/CaptionKeyWord 'Incremental_ABZ'					
					/OnSelect [A	
						[D /Name 'Feedback_Selection' /Value 1 ]					  
						[D /Name 'Double_Feedback_Check' /Value 1 ]					  
						[D /Name 'Com_BackEMFCalcSource' /Value 2 ]					  						
					]
				]																											
				[D
					/Value 2
					/CaptionKeyWord 'Analog_Sine_Cosine'					
					/OnSelect [A	
						[D /Name 'Feedback_Selection' /Value 1 ]					  
						[D /Name 'Double_Feedback_Check' /Value 1 ]					  
						[D /Name 'Com_BackEMFCalcSource' /Value 2 ]					  						
					]
				]																											
				[D
					/Value 3
					%/Caption 'Absolute Sensor'					
					/Hide #1
					/OnSelect [A	
						[D /Name 'Feedback_Selection' /Value 1 ]					  
						[D /Name 'Double_Feedback_Check' /Value 1 ]					  
						[D /Name 'Com_BackEMFCalcSource' /Value 0 ]					  						
					]
				]																											
				[D
					/Value 7
					/CaptionKeyWord 'Encoder_Simulation'					
					/OnSelect [A	
						[D /Name 'Feedback_Selection' /Value 0 ]					  
						[D /Name 'Double_Feedback_Check' /Value 0 ]					  
						[D /Name 'Com_BackEMFCalcSource' /Value 1 ]					  
					]
				]																											
			]	
		]      	   		   		   	  	   
		[D
			/Name 'ExtSensor_Direction'
			/TreeUPID 4701
			/Type 'ENUM'
			/StartWithTreeValue #1
			/OnChange [A ]  
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'Positive'					
					/OnSelect [A	
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Negative'					
					/OnSelect [A	
					]
				]																											
			]	
		]      	   		   		
		[D
			/Name 'ExtSen_WaveForm_Table'
			/TreeUPID 4720
			/Type 'ENum'
			/DefValue 1
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   	
		]	   		   	
		[D
			/Name 'ExtSen_FFT_C1'
			/TreeUPID 4721
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'ExtSen_FFT_C3'
			/TreeUPID 4722 
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'ExtSen_FFT_C5'
			/TreeUPID 4723
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'ExtSen_FFT_C7'
			/TreeUPID 4724
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'ExtSen_FFT_C9'
			/TreeUPID 4725
			/Type 'DOUBLE'
		]	   		   										
		[D
			/Name 'ExtSensor_Resolution'
			/TreeUPID 4702
			/StartWithTreeValue #1
			/OnChange [A ]  
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'ExtSensor_SpeedTime'
			/TreeUPID 4706
			/StartWithTreeValue #1
			/OnChange [A ]  
			/Type 'DOUBLE'
		]      	   		   		   	  	            	   		   		   	  	      
		[D
			/Name 'ExtSensor_MinEdgeSep'
			/TreeUPID 4730
			/StartWithTreeValue #1
			/OnChange [A ]  
			/Type 'DOUBLE'
		]      	   		   		   	  	            	   		   		   	  	      
		% POSITION RECOVERY CONFIGURATION BEGIN
		[D
			/Name 'PosRec_PositionTolerance'
			/StartWithTreeValue #1
			/TreeUPID 5089
			/Type 'DOUBLE'
		]
		% ANALOG and InPeriod
		[D
			/Name 'PosRec_AnalogSourceSelection'
			/TreeUPID 5097
			/Type 'ENUM'
			/StartWithTreeValue #1
			/ENumDef [A
				[D
					/Value 1
					/OnSelect [A	
					]
				]																											
				[D
					/Value 2
					/OnSelect [A	
					]
				]																											
			]	
		]	   		   		
		[D
			/Name 'PosRec_0VPosition'
			/StartWithTreeValue #1
			/TreeUPID 5098
			/Type 'DOUBLE'
		]
		[D
			/Name 'PosRec_10VPosition'
			/StartWithTreeValue #1
			/TreeUPID 5099
			/Type 'DOUBLE'
		]		
		% SSI		
		[D
			/Name 'PosRec_SSIResolution'
			/TreeUPID 5090
			/Type 'DOUBLE'
			/StartWithTreeValue #1
		]	   		   	
		[D
			/Name 'PosRec_SSIReadingPulseWidth'
			/TreeUPID 5091
			/Type 'DOUBLE'
			/StartWithTreeValue #1
		]	   		   	
		[D
			/Name 'PosRec_SSINumberOfReadingBits'
			/TreeUPID 5092
			/Type 'DOUBLE'
			/StartWithTreeValue #1
		]	   		   	
		[D
			/Name 'PosRec_SSINumberOfPositionBits'
			/TreeUPID 5093
			/Type 'DOUBLE'
			/StartWithTreeValue #1
		]	   		   	
		[D
			/Name 'PosRec_SSIPositionDecoding'
			/TreeUPID 5094
			/Type 'ENUM'
			/StartWithTreeValue #1
			/ENumDef [A
				[D
					/Value 0
					/OnSelect [A
					]
				]																											
				[D
					/Value 1
					/OnSelect [A	
					]
				]																											
			]	
		]	   		   	
		[D
			/Name 'PosRec_SSICountDirection'
			/TreeUPID 5347
			/StartWithTreeValue #1
			/Type 'ENUM'
			/ENumDef [A
				[D
					/Value 0
					/OnSelect [A
					]
				]																											
				[D
					/Value 1
					/OnSelect [A	
					]
				]																											
			]	
		]	   		   	
		
		[D
			/Name 'PosRec_SSIPositionOffset'
			/TreeUPID 5345
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'PosRec_SSIPositionOffsetValid'
			/TreeUPID 5346
			/Type 'BOOLEAN'
		]  
		
		[D
			/Name 'PosRec_Mode'
			/TreeUPID 5088
			/Type 'ENUM'
			/StartWithTreeValue #1
			/ENumDef [A
				[D
					/Value 0
					/OnSelect [A
					]
				]																											
				[D
					/Value 1
					/OnSelect [A	
					]
				]																											
				[D
					/Value 2
					/OnSelect [A	
					]
				]																											
				[D
					/Value 4
					/OnSelect [A
						
					]
				]																											
			]	
		]      	   		   		   	  	   
		
		[D
			/Name 'PosRec_SSITypeCode'
			/TreeUPID 5344
			/Type 'ENUM'
			/DefValue 4
			/StartWithTreeValue #1
			/ENumDef [A
				[D
					/Value 4
					/Caption 'MS01-1/D-SSI'
					/OnSelect [A
						[D /Name 'PosRec_SSIResolution' /Value 0.000005 ]      	     	
						[D /Name 'PosRec_SSIReadingPulseWidth' /Value 0.000002 ]      	     	
						[D /Name 'PosRec_SSINumberOfReadingBits' /Value 31.0 ]      	     	
						[D /Name 'PosRec_SSINumberOfPositionBits' /Value 24.0 ]      	     	
						[D /Name 'PosRec_SSIPositionDecoding' /Value 0]      	     	
					]
				]																							
				[D
					/Value 3
					/Caption 'MSA501'
					/Hide #1
					/OnSelect [A
						[D /Name 'PosRec_SSIResolution' /Value 0.000005 ]      	     	
						[D /Name 'PosRec_SSIReadingPulseWidth' /Value 0.000002 ]      	     	
						[D /Name 'PosRec_SSINumberOfReadingBits' /Value 31.0 ]      	     	
						[D /Name 'PosRec_SSINumberOfPositionBits' /Value 24.0 ]      	     	
						[D /Name 'PosRec_SSIPositionDecoding' /Value 0]      	     	
					]																					
				]		
				[D
					/Value 1
					/Hide #1
					/Caption 'MSA111'
					/OnSelect [A
						[D /Name 'PosRec_SSIResolution' /Value 0.000001 ]      	     	
						[D /Name 'PosRec_SSIReadingPulseWidth' /Value 0.0000008 ]      	     	
						[D /Name 'PosRec_SSINumberOfReadingBits' /Value 24.0 ]      	     	
						[D /Name 'PosRec_SSINumberOfPositionBits' /Value 24.0 ]      	     	
						[D /Name 'PosRec_SSIPositionDecoding' /Value 0]      	     	
					]
				]																											
				[D
					/Value 2
					/Caption 'Generic'
					%/Hide #1
					/OnSelect [A	
					]
				]																											
			]	
		]	   		   			
		
		% POSITION RECOVERY CONFIGURATION END
		
		% COMMUTATION BEGIN
		[D
			/Name 'Com_NumberOfPhases'
			/TreeUPID 4590
			/Type 'ENum'
			/DefValue 2  % Phases
			/ENumDef [A  
				[D
					/Value 1
					%/Caption '1 Phase'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption '2 Phases'					
					/OnSelect [A ]
				]																											
				[D
					/Value 3
					%/Caption '3 Phases'					
					/OnSelect [A ]
				]																											   	   		
			] 	   		   		   	
		]
		[D
			/Name 'Com_Ph1ToPh2Angle'
			/TreeUPID 4597
			/DefValue -1.57079632679489 
			/Type 'DOUBLE'
		]      	   		   		   	  	      		   		   	
		[D
			/Name 'Com_AngleInfoSource'
			/TreeUPID 4591
			/Type 'ENum'
			/DefValue 1  % SIN/COS Motor Sensor
			/ENumDef [A
				[D
					/Value 1
					%/Caption 'SIN/COS on X3 Motor Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'SIN/COS on X12 External Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 3
					%/Caption 'Sensor Position On X3'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 7
					%/Caption 'AB Sensor Position on X12'					
					/OnSelect [A ]
				]																											   	   		   						
				[D
					/Value 4
					%/Caption 'ABZ Sensor Position on X12'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 5
					%/Caption 'Hall Switches on X3'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 6
					%/Caption 'Hall Switches on X10'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 0
					%/Caption 'External'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   	
		]	   		   	
		[D
			/Name 'Com_InitMode'
			/TreeUPID 4592
			/Type 'ENum'
			/DefValue 0  % None
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'Alpha Shot on X3'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Alpha Shot on X12'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 5
					%/Caption 'Hall Switches on X3 Until First Z'					
					/OnSelect [A ]
				]																											   	   		   						
				[D
					/Value 6
					%/Caption 'Hall Switches on X10 Until First Z'					
					/OnSelect [A ]
				]	
				[D
					/Value 7
					%/Caption 'Phase Search First Switch On'					
					/OnSelect [A ]
				]	
				[D
					/Value 13
					%/Caption 'Hall Switches On X3 Until Hall Switch Edge'					
					/OnSelect [A ]
				]	
				[D
					/Value 14
					%/Caption 'Hall Switches On X10 Until Hall Switch Edge'					
					/OnSelect [A ]
				]																										   	   		   		
			] 	   		   		   	
		]	   		   	
		[D
			/Name 'Com_PeriodLength'
			/TreeUPID 4593
			/DefValue 0.06 
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'Com_PhaseAngle'
			/TreeUPID 4594
			/DefValue 4.7123889803846898576939650749193
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'Com_DeathTimeCompensation'
			/TreeUPID 4595
			/Type 'DOUBLE'
		]      	   		  
		[D
			/Name 'Invert_Hall_Switches'
			/TreeUPID 4598
			/Type 'ENUM'	
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Off'
					/OnSelect [A ]
				]
				[D
					/Value 1
					%/Caption 'On'
					/OnSelect [A ]
				]	
			]				
		] 		   	  	   
		[D
			/Name 'Com_BackEMFCalcSource'
			/TreeUPID 4596
			/Type 'ENUM'
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'Demand Velocity'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'Velocity of X3 Feedback'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Velocity of X12 Feedback'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   	
		]      	   		   		   	  	   
		[D
			/Name 'Com_CommutationTable'
			/TreeUPID 4530
			/DefValue 1 % IFFT Calculated			
			/Type 'ENUM'
			/ENumDef [A  
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   	
		]      	   		   		   	  	   
		[D
			/Name 'Com_FFT_C1'
			/TreeUPID 4531
			/DefValue 1.0683 	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_FFT_C3'
			/TreeUPID 4532
			/DefValue -0.0007 	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_FFT_C5'
			/TreeUPID 4533
			/DefValue -0.0699 	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_FFT_C7'
			/TreeUPID 4534
			/DefValue 0.0 	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com C9'
			/TreeUPID 4535
			/DefValue 0.0008 	   		   		   	
			/Type 'DOUBLE'
		]	   		   										
		[D
			/Name 'Com_BackEMFTable'
			/TreeUPID 4540
			/DefValue 1 % IFFT Calculated			
			/Type 'ENUM'
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   	
		]      	   		   		   	  	   
		[D
			/Name 'Com_BackEMF_C1'
			/TreeUPID 4541
			/DefValue 0.936	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_BackEMF_C3'
			/TreeUPID 4542
			/DefValue -0.0612 	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_BackEMF_C5'
			/TreeUPID 4543
			/DefValue -0.0006 	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_BackEMF_C7'
			/TreeUPID 4544
			/DefValue -0.0033	   		   		   	
			/Type 'DOUBLE'
		]	   		   	
		[D
			/Name 'Com_BackEMF_C9'
			/TreeUPID 4545
			/DefValue 0.0 	   		   		   	
			/Type 'DOUBLE'
		]	   		   										
		% COMMUTATION END
		
		% SLIDER BEGIN   	
		[D
			/Name 'Slider'
			/TreeUPID 6202
			/Type 'ENUM'
			/OnChange [A
				[D	/Name 'CalculateMotorProperty']				
				[D /Name 'CalculateFFValues' ]
				[D /Name 'CalculateStrokeRange' ]				
				[D /Name 'Module_BuildActuatorName' ]					
			]
			/ENumDef [A
				[D
					/Value 51
					/Caption 'PL01-27x350@/270'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x350@/270' ]
						[D	/Name 'Slider_Length'	/Value 0.35	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.27	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 1.358	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1467'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]																											
				[D
					/Value 52
					/Caption 'PL01-27x410@/330'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x410@/330' ]
						[D	/Name 'Slider_Length'	/Value 0.41	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.33	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 1.618	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1468'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]																											
				[D
					/Value 53
					/Caption 'PL01-27x500@/420'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x500@/420' ]
						[D	/Name 'Slider_Length'	/Value 0.5	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.42	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 2.16	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1469'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]																
				[D
					/Value 54
					/Caption 'PL01-27x620@/540'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x620@/540' ]
						[D	/Name 'Slider_Length'	/Value 0.62	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.54	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 2.53	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1470'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]															
				[D
					/Value 55
					/Caption 'PL01-27x710@/630'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x710@/630' ]
						[D	/Name 'Slider_Length'	/Value 0.71	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.63	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 2.92	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1471'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]															
				[D
					/Value 56
					/Caption 'PL01-27x800@/720'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x800@/720' ]
						[D	/Name 'Slider_Length'	/Value 0.8	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.72	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 3.31	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1472'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]															
				[D
					/Value 57
					/Caption 'PL01-27x920@/840'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x920@/840' ]
						[D	/Name 'Slider_Length'	/Value 0.92	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.84	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 3.83	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1447'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]															
				[D
					/Value 58
					/Caption 'PL01-27x1010@/930'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Slider_Name' /Value 'PL01-27x1010@/930' ]
						[D	/Name 'Slider_Length'	/Value 1.01	]
						[D	/Name 'Slider_ActiveLength'	/Value 0.93	]
						[D	/Name 'Slider_EndPieceLength'	/Value 0.024	]
						[D	/Name 'Slider_Mass'	/Value 4.22	]																
						[D /Name 'Slider_ArtNr'	/Value '0150-1473'	]
						[D /Name 'Slider_PolePitch' /Value 0.03 ]
					]								
				]															
			]																		
		]	
		
		% SLIDER DIRECTION   	
		[D
			/Name 'Slider_Direction'
			/CaptionKeyWord 'Slider_Direction'
			/TreeUPID 6211
			/Type 'ENUM'
			/DefValue 1
			/StartWithTreeValue #0
			/OnChange [A
				[D	/Name 'CalculateMotorProperty']				
				[D /Name 'CalculateFFValues' ]
				[D /Name 'CalculateStrokeRange' ]				
				[D /Name 'Module_BuildActuatorName' ]				
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'Regular'					
					/OnSelect [A
					]								
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Reversed'
					/OnSelect [A
					]								
				]																											
			]
		]		
		
		% SLIDER END
		
		% STATOR SUB TYPE
		[D
			/Name 'StatorSubType'
			/TreeUPID 4614
			/Type 'ENUM'
			/DefValue -1
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateMotorProperty']				
				[D /Name 'CalculateFFValues' ]
				[D /Name 'CalculateStrokeRange' ]				
				[D /Name 'Module_BuildActuatorName' ]	
			]
			/ENumDef [A
				[D
					/Value 0
					/Caption 'PS01-48x240-C'					
					/DescriptionKeyWord 'Connector_Type'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Stator_Name' /Value 'PS01-48x240-C' ]
						[D /Name 'Stator_Type_Code' /Value 8	]					
						[D /Name 'StatorInfoBlock_ArtNr' /Value 1219 ]
						[D /Name 'Stator_ArtNr' /Value '0150-1219' ]
						[D /Name 'Stator_Length' /Value 0.2895 ]				
						[D /Name 'Stator_Mass'	/Value 1.930 ]
						[D /Name 'Motor_Name_Extension' /Value '-C'] 
					]									
				]
				[D
					/Value 1
					/Caption 'PS01-48x240F-C'					
					/DescriptionKeyWord 'Connector_Type'					
					/ShowWithCompanyPrefix #1									
					/OnSelect [A
						[D /Name 'Stator_Name' /Value 'PS01-48x240F-C' ]
						[D /Name 'Stator_Type_Code' /Value 9	]					
						[D /Name 'StatorInfoBlock_ArtNr' /Value 1220 ]
						[D /Name 'Stator_ArtNr' /Value '0150-1220' ]
						[D /Name 'Stator_Length' /Value 0.2895 ]				
						[D /Name 'Stator_Mass'	/Value 1.930 ]
						[D /Name 'Motor_Name_Extension' /Value '-C'] 
					]									
				]																											
			]																		
		]	
		
		% END STATOR SUB TYPE
		
		% GUIDE UNIT BEGIN   	
		[D
			/Name 'GuideUnitType'
			/TreeUPID 6239
			/Type 'ENUM'
			/DefValue -1
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateMotorProperty']				
				[D /Name 'CalculateFFValues' ]
				[D /Name 'CalculateStrokeRange' ]			
				[D /Name 'Module_BuildActuatorName' ]	
			]
			/ENumDef [A
				[D
					/Value 0
					/Caption 'B01-48x250/90'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Ball_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/90' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5150' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.090 ]
						[D /Name 'GuideUnit_SliderMass' /Value 1.610 ]		%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.105 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 52 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed		
						[D /Name 'Module_Name_Extension' /Value '90' ]										
					]									
				]		
				[D
					/Value 1
					/Caption 'B01-48x250/180'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Ball_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/180' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5151' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.180 ]
						[D /Name 'GuideUnit_SliderMass' /Value 1.860 ]		%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.195 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 53 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed		
						[D /Name 'Module_Name_Extension' /Value '180' ]										
					]									
				]
				[D
					/Value 2
					/Caption 'B01-48x250/300'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Ball_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/300' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5152' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.300 ]
						[D /Name 'GuideUnit_SliderMass' /Value 2.230 ]	%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.315 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 54 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed	
						[D /Name 'Module_Name_Extension' /Value '300' ]										
					]									
				]
				[D
					/Value 3
					/Caption 'B01-48x250/390'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Ball_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/390' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5153' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.390 ]
						[D /Name 'GuideUnit_SliderMass' /Value 2.460 ]	%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.405 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 55 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed	
						[D /Name 'Module_Name_Extension' /Value '390' ]											
					]									
				]
				[D
					/Value 4
					/Caption 'B01-48x250/90-GF'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Plain_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/90-GF' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5154' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.090 ]
						[D /Name 'GuideUnit_SliderMass' /Value 1.610 ]		%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.105 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 52 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed		
						[D /Name 'Module_Name_Extension' /Value '90' ]										
					]									
				]		
				[D
					/Value 5
					/Caption 'B01-48x250/180-GF'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Plain_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/180-GF' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5155' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.180 ]
						[D /Name 'GuideUnit_SliderMass' /Value 1.860 ]		%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.195 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 53 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed		
						[D /Name 'Module_Name_Extension' /Value '180' ]										
					]									
				]
				[D
					/Value 6
					/Caption 'B01-48x250/300-GF'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Plain_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/300-GF' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5156' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.300 ]
						[D /Name 'GuideUnit_SliderMass' /Value 2.230 ]	%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.315 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 54 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed	
						[D /Name 'Module_Name_Extension' /Value '300' ]										
					]									
				]
				[D
					/Value 7
					/Caption 'B01-48x250/390-GF'	
					/ShowWithCompanyPrefix #1					
					/DescriptionKeyWord 'Plain_Bearings'				
					/OnSelect [A
						[D /Name 'GuideUnit_Name' /Value 'B01-48x250/390-GF' ]
						[D /Name 'GuideUnit_ArtNr' /Value '0150-5157' ]
						[D /Name 'GuideUnit_NominalStroke' /Value 0.390 ]
						[D /Name 'GuideUnit_SliderMass' /Value 2.460 ]	%Masse welche an den Lufer gekoppelt wird (nicht unbedingt gleich bewegtes Teil)
						[D /Name 'GuideUnit_StatorMass' /Value 3.600 ] 	%Masse welche mit dem Stator gekoppelt wird (nicht unbedingt gleich stehendes Teil)
						[D /Name 'GuideUnit_SliderHomePosNegative' /Value 0.007 ]
						[D /Name 'GuideUnit_SliderHomeGapNegative' /Value 0.006 ]
						[D /Name 'GuideUnit_SliderHomePosPositive' /Value 0.405 ]
						[D /Name 'GuideUnit_SliderHomeGapPositive' /Value 0.002	]	
						[D /Name 'Slider' /Value 55 ]
						[D /Name 'Slider_Direction' /Value 1]	% Reversed	
						[D /Name 'Module_Name_Extension' /Value '390' ]											
					]									
				]
			]
		]
		
		% GUIDE UNIT END   	
		
		
		% FLANGE BEGIN
		[D
			/Name 'Cooling'
			/CaptionKeyWord 'Cooling'
			/TreeUPID 6203
			/Type 'ENUM'
			/DefValue -1
			/StartWithTreeValue #1
			/OnChange [A 
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Forced_Cooling'
					/OnSelect [A	
						[D /Name 'TempModelPar_RMountingEnvironment' /Value 0.866 ] 
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Forced_Cooling'
					/OnSelect [A	
						[D /Name 'TempModelPar_RMountingEnvironment' /Value  0.126 ] 
					]
				]																											
			]	
		]      	   		   		   	  	   		
		% FLANGE END
		
		% HOMING BEGIN		
		[D
			/Name 'Home_Mode'
			/CaptionKeyWord 'Homing_Mode'
			/TreeUPID 5060
			/Type 'ENUM'
			/DefValue 1
			/StartWithTreeValue #1
			/OnChange [A
				[D /Name 'CalculateStrokeRange' ]				
			]
			/ENumDef [A
				[D
					/Value 0
					/Hide #1
					%/Caption 'Actual Position'	
					/DescriptionKeyWord 'HomeMode0_Info'				
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 1					
					/CaptionKeyWord 'HomeMode1_Module_Caption'
					/DescriptionKeyWord 'HomeMode1_Module_Info'				
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 2
					/CaptionKeyWord 'HomeMode2_Module_Caption'
					/DescriptionKeyWord 'HomeMode2_Module_Info'				
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 14
					/Hide #1
					%/Caption 'Limit Switch Negative'					
					/DescriptionKeyWord 'HomeMode14_Info'				
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]			
				[D
					/Value 15
					/Hide #1
					%/Caption 'Limit Switch Positive'					
					/DescriptionKeyWord 'HomeMode15_Info'				
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																										
				[D
					/Value 3
					/Hide #1
					%/Caption 'Home Switch'	
					/DescriptionKeyWord 'HomeMode3_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]					
				[D
					/Value 16
					/Hide #1
					%/Caption 'Home Switch'	
					/DescriptionKeyWord 'HomeMode16_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]					
				[D
					/Value 4
					/Hide #1
					%/Caption 'Home Switch And Mechanical Stop Negative'					
					/DescriptionKeyWord 'HomeMode4_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 5
					/Hide #1
					%/Caption 'Home Switch And Mechanical Stop Positive'					
					/DescriptionKeyWord 'HomeMode5_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]				
				[D
					/Value 6
					/Hide #1
					%/Caption 'Home Switch And Limit Switch Negative'					
					/DescriptionKeyWord 'HomeMode6_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 7
					/Hide #1
					%/Caption 'Home Switch And Limit Switch Positive'					
					/DescriptionKeyWord 'HomeMode7_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]				
				[D
					/Value 8
					/Hide #1
					%/Caption 'Index On X12 And Mechanical Stop Negative'					
					/DescriptionKeyWord 'HomeMode8_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 9
					/Hide #1
					%/Caption 'Index On X12 And Mechanical Stop Positive'					
					/DescriptionKeyWord 'HomeMode9_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]				
				[D
					/Value 10
					/Hide #1
					%/Caption 'Index On X12 And Limit Switch Negative'					
					/DescriptionKeyWord 'HomeMode10_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 11
					/Hide #1
					%/Caption 'Index On X12 And Limit Switch Positive'					
					/DescriptionKeyWord 'HomeMode11_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]					
				[D
					/Value 12
					/Hide #1
					%/Caption 'Index On X12 Negative Search'					
					/DescriptionKeyWord 'HomeMode12_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																											
				[D
					/Value 13
					/Hide #1
					%/Caption 'Index On X12 Positive Search'					
					/DescriptionKeyWord 'HomeMode13_Info'													
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #1 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #1 ] 
					]
				]																																							
				[D
					/Value 17
					%/Caption 'No Drive Homing'					
					/DescriptionKeyWord 'HomeMode17_Info'													
					/Hide #0
					/OnSelect [A 
						%[D /Name 'ErrMask_MinimalPosition' /Value #0 ] 
						%[D /Name 'ErrMask_MaximalPosition' /Value #0 ] 
					]
				]																																							
			]	
		]      	   		   		   	  	  
		[D
			/Name 'HomeConf_CurrentLimit'
			/TreeUPID 5061
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'HomeConf_FollowingErrorLimit'
			/TreeUPID 5062
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'HomeConf_HomePosition'
			/TreeUPID 5063
			/StartWithTreeValue #0
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'HomeConf_MaxSpeed'
			/TreeUPID 5064
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'HomeConf_Acceleration'
			/TreeUPID 5065
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		[D
			/Name 'HomeConf_SliderHomePosition'
			/TreeUPID 5066
			/StartWithTreeValue #0
			/Type 'DOUBLE'
		]      	   		 
		% HOMING BEGIN		
		
		% CHECK POS CONFIG BEGIN
		[D
			/Name 'CheckPos_AutoOnHoming'
			/TreeUPID 5070
			/Type 'ENUM'
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Disable'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Enable'					
					/OnSelect [A ]
				]																											
			]	
		]      	   		 
		[D
			/Name 'CheckPos_Position1'
			/TreeUPID 5071
			/Type 'DOUBLE'
		]      	   		 
		[D
			/Name 'CheckPos_Position2'
			/TreeUPID 5072
			/Type 'DOUBLE'
		]      	   		 
		[D
			/Name 'CheckPos_MaxSpeed'
			/TreeUPID 5073
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'CheckPos_Acceleration'
			/TreeUPID 5074
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		[D
			/Name 'CheckPos_Decceleration'
			/TreeUPID 5075
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		
		% CHECK POS CONFIG END
		
		% INITIAL POS CONFIG BEGIN
		[D
			/Name 'InitialPosConf_AutoOnHoming'
			/TreeUPID 5080
			/Type 'ENUM'
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Disable'					
					/OnSelect [A	
					]
				]																											
				[D
					/Value 1
					%/Caption 'Enable'					
					/OnSelect [A	
					]
				]																											
			]							
		]      	   		 
		[D
			/Name 'InitialPosConf_Position'
			/TreeUPID 5081
			/Type 'DOUBLE'
			/StartWithTreeValue #0
			
		]      	   		   		   	  	   
		[D
			/Name 'InitialPosConf_MaxSpeed'
			/TreeUPID 5082
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'InitialPosConf_Acceleration'
			/TreeUPID 5083
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		[D
			/Name 'InitialPosConf_Decceleration'
			/TreeUPID 5084
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 		  		 		  				  		   	  	   
		% INITIAL POS CONFIG END
		
		% POSITION MONITORING BEGIN
		[D
			/Name 'Minimal_Position'
			/TreeUPID 5230
			/StartWithTreeValue #1
			/CaptionKeyWord 'Min_Pos_Stroke_Range'
			/Type 'DOUBLE'
			/OnChange [A	[D	/Name 'CalculateStrokeRange'	]	]
		]      	   		   		   	  	   								 
		[D
			/Name 'Maximal_Position'
			/TreeUPID 5231
			/StartWithTreeValue #1
			/CaptionKeyWord 'Max_Pos_Stroke_Range'
			/Type 'DOUBLE'
			/OnChange [A	[D	/Name 'CalculateStrokeRange'	]	]
		]      	   		   		   	  	   								 
		% POSITION MONITORING END
		
		% FF SETUP BEGIN
		[D
			/Name 'Move_Part'
			/TreeUPID 6204
			/Type 'ENUM'
			/DefValue 0
			/StartWithTreeValue #1
			/OnChange [A 
				[D /Name 'CalculateFFValues' ]
			]  
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'Slider'					
					/OnSelect [A	
					]
				]																											
				[D
					/Value 1
					/Hide #0
					/CaptionKeyWord 'Stator'					
					/OnSelect [A	
					]
				]																											
				[D
					/Value 2
					/Hide #1
					/CaptionKeyWord 'Stator+PF01-23x120'
					/OnSelect [A	]
				]																											
			]	
		]      	   		   		   	  	   
		[D
			/Name 'Additional_Mass'
			/TreeUPID 6205
			/StartWithTreeValue #1
			/OnChange [A 
				[D /Name 'CalculateFFValues' ]
			]  
			/Type 'DOUBLE'
		]      	   		   
		[D
			/Name 'Total_Load_Mass'		% new parameter since 3.7 (used e.g. for MPC Move calculation)
			/TreeUPID 6240
			/OnChange [A 
			]  
			/Type 'DOUBLE'
		]      	   		   		   	  	   				   	  	   
		[D
			/Name 'Orientation'
			/TreeUPID 6206
			/StartWithTreeValue #1
			/MinValue -1.5707963267948966192313216916398
			/MaxValue 1.5707963267948966192313216916398
			/OnChange [A 
				[D /Name 'CalculateFFValues' ]
			]  
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'Dry_Friction'
			/TreeUPID 6207
			/StartWithTreeValue #1
			/OnChange [A 
				[D /Name 'CalculateFFValues' ]
			]  
			/Type 'DOUBLE'
		]   
		[D
			/Name 'Viscous_Friction'
			/TreeUPID 6236
			/CaptionKeyWord 'Viscous_Friction'
			/StartWithTreeValue #1
			/OnChange [A 
				[D /Name 'CalculateFFValues' ]
			]  
			/Type 'DOUBLE'
		]   
		
		
		
		[D
			/Name 'Constant_Force'
			/TreeUPID 6237
			/CaptionKeyWord 'Constant_Force'
			/StartWithTreeValue #1
			/OnChange [A 
				[D /Name 'CalculateFFValues' ]
			]  
			/Type 'DOUBLE'
		]   
		
		[D	
			/Name 'Force_Direction'
			/TreeUPID 6238
			/CaptionKeyWord 'Force_Direction'
			/Type 'ENUM'
			/DefValue 0
			/StartWithTreeValue #1
			/OnChange [A
				[D /Name 'CalculateFFValues' ]
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'Negative'					
					/OnSelect [A
					]								
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Positive'
					/OnSelect [A
					]								
				]																											
			]
		]		
		
		
		
		% FF SETUP END
		
		% CONTROL PARAMETER BEGIN
		[D
			/Name 'ControlParameter_SetSelection'
			/TreeUPID 5011
			/Type 'ENUM'
			/DefValue 0
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Control Parameter Set A'					
					/OnSelect [A	]
				]																											
				[D
					/Value 1
					%/Caption 'Control Parameter Set B'					
					/OnSelect [A	]
				]																											
			]	
		]      	   		   		   	  	   
		% CONTROL PARAMETER SET A
		[D
			/Name 'FF_ConstForce_SetA'
			/TreeUPID 5020
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Friction_SetA'
			/TreeUPID 5021
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Spring_SetA'
			/TreeUPID 5022
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Damping_SetA'
			/TreeUPID 5023
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Acceleration_SetA'
			/TreeUPID 5024
			/Type 'DOUBLE'
		]      	   		   		 
		[D
			/Name 'Spring_ZP_SetA'
			/TreeUPID 5025
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'P_Gain_SetA'
			/TreeUPID 5026
			/StartWithTreeValue #1
			/DefValue 2000.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'D_Gain_SetA'
			/TreeUPID 5027
			/StartWithTreeValue #1
			/DefValue 3.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'I_Gain_SetA'
			/TreeUPID 5028
			%/Caption 'I Gain'
			/StartWithTreeValue #1
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'D_FilterTime_SetA'
			/TreeUPID 5032
			/StartWithTreeValue #1
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'IntegratorLimit_SetA'
			/TreeUPID 5029
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'MaxCurrent_SetA'
			/TreeUPID 5030
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'NoiseDeadBandSetA'
			/TreeUPID 5031
			/Type 'DOUBLE'
			/CaptionKeyWord 'NoiseFilterDeadband'
			/StartWithTreeValue #1
			/DefValue 0.00003
		]      	   		   		   	  	      
		
		
		% WARNING MASK BEGIN
		[D
			/Name 'WarnMask_MotorTempSensor'
			/TreeUPID 5580
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorHotCalculated'
			/TreeUPID 5581
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorVoltageLow'
			/TreeUPID 5582
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorVoltageHigh'
			/TreeUPID 5583
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_FollowingWarnMoving'
			/TreeUPID 5584
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_FollowingWarnStanding'
			/TreeUPID 5585
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MCBoardTemperature'
			/TreeUPID 5586
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorNotHomed'
			/TreeUPID 5587
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_PTCTempSens1'
			/TreeUPID 5588
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_PTCTempSens2'
			/TreeUPID 5589
			/Type 'BOOLEAN'
		] 
		
		[D
			/Name 'WarnMask_BleederHotCalculated'
			/TreeUPID 5590
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_InterfaceSWWarnFlag'
			/TreeUPID 5594
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_ApplicationSWWarnFlag'
			/TreeUPID 5595
			/Type 'BOOLEAN'
		] 
		% WARNING MASK END
		
		% ERROR MASK BEGIN
		[D
			/Name 'ErrMask_LogicVoltageLow'
			/TreeUPID 5500
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_LogicVoltageHigh'
			/TreeUPID 5501
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorVoltageLow'
			/TreeUPID 5502
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorVoltageHigh'
			/TreeUPID 5503
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorHotCalculated'
			/TreeUPID 5504
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorTempSensor'
			/TreeUPID 5505
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_PTCTempSensor'
			/TreeUPID 5506
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MCBoardTemperature'
			/TreeUPID 5507
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorSliderMissing'
			/TreeUPID 5508
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorHallSignalMissing'
			/TreeUPID 5509
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_ExtPosSensor'
			/TreeUPID 5510
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_FollowingWarnMoving'
			/TreeUPID 5511
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_FollowingWarnStanding'
			/TreeUPID 5512
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_PhaseGNDPathError'
			/TreeUPID 5513
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_PhasePWRVolPathError'
			/TreeUPID 5514
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_OverCurrent'
			/TreeUPID 5515
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MinimalPosition'
			/TreeUPID 5516
			/StartWithTreeValue #1
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MaximalPosition'
			/TreeUPID 5517
			/StartWithTreeValue #1
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_BleederCheck'
			/TreeUPID 5518
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_BleederTempCalculated'
			/TreeUPID 5519
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_CheckStatorType'
			/TreeUPID 5520
			/Type 'BOOLEAN'
		] 
		% ERROR MASK END
		
		
		% TEMPERATURE MONITORING BEGIN
		[D
			/Name 'Temp_Sensor_Type'
			/TreeUPID 4656
			/Type 'ENUM'
			/DefValue 2			
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'Communication'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Switch Active Low'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 3
					%/Caption 'KTY'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   							
		] 
		[D
			/Name 'TempSens_WarnTime'
			/TreeUPID 4601
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempSens_ErrorTime'
			/TreeUPID 4602
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Communication_Type'
			/TreeUPID 4603
			/Type 'ENUM'
			/DefValue 1			
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'P01'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   							
		] 
		[D
			/Name 'NrOfMotTemp_Values'
			/TreeUPID 4604
			/Type 'DOUBLE'
			/DefValue 4.0
		] 
		[D
			/Name 'TakeCorrectionValueMask_SineOffset'
			/TreeUPID 4670
			/Type 'BOOLEAN'
			/DefValue #1
		] 
		[D
			/Name 'TakeCorrectionValueMask_CosineOffset'
			/TreeUPID 4671
			/Type 'BOOLEAN'
			/DefValue #1
		] 
		[D	
			/Name 'TakeCorrectionValueMask_CosSinRelGain'
			/TreeUPID 4672
			/Type 'BOOLEAN'
			/DefValue #1
		]
		[D 
			/Name 'TakeCorrectionValueMask_SensorDistError'
			/TreeUPID 4673
			/Type 'BOOLEAN'
			/DefValue #1
		] 		
		[D 
			/Name 'TakeCorrectionValueMask_MaximalMotorTemp'
			/TreeUPID 4674
			/Type 'BOOLEAN'
			/DefValue #1
		] 				
		[D 
			/Name 'TakeCorrectionValueMask_CommutationAngle'
			/TreeUPID 4675
			/Type 'BOOLEAN'
			/DefValue #1
		] 				
		[D
			/Name 'PhaseResistence_TempCorrection'
			/TreeUPID 4615
			/Type 'ENUM'
			/DefValue 1
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Off'					
					/OnSelect [A	]
				]																											
				[D
					/Value 1
					%/Caption 'Temperature Calculated'					
					/OnSelect [A	]
				]																											
				[D
					/Value 2
					%/Caption 'Temperature Read Out'
					/OnSelect [A 	]
				]																											
			]	
		] 
		[D
			/Name 'TempModelPar_CWinding'
			/TreeUPID 4620
			/DefValue 231.0
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_CWOut'
			/TreeUPID 4623
			/DefValue 23.1
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_CHousing'
			/TreeUPID 4625
			/DefValue 509.0 
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_CMounting'
			/TreeUPID 4627
			/DefValue 1761.0 
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_RWindingWinding'
			/TreeUPID 4621
			/DefValue 0.34
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_RWindingWOut'
			/TreeUPID 4622
			/DefValue 0.255
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_RWOutHousing'
			/TreeUPID 4624
			/DefValue 0.145 
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_RHousingMounting'
			/TreeUPID 4626
			/DefValue 0.015
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_RMountingEnvironment'
			/TreeUPID 4628
			/DefValue 0.866 
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_EnvironmentTemp'
			/TreeUPID 4629
			/DefValue 25.0 
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempModelPar_MaxWindingTemp'
			/TreeUPID 4612
			/Type 'DOUBLE'
		] 
		
		% NEW I^2t TEMPERATURE MODEL
		
		[D
			/Name 'C_Winding'
			/TreeUPID 4650
			/DefValue 231.0
			/Type 'DOUBLE'
		] 
		[D
			/Name 'R_WindingOutside'
			/TreeUPID 4651
			/DefValue 0.17
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Temp_WindingOutside'
			/TreeUPID 4653
			/DefValue 90.0
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Warn_Temp'
			/TreeUPID 4610
			/DefValue 110.0
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Error_Temp'
			/TreeUPID 4611
			/DefValue 120.0
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Warn_Temp_Off'
			/TreeUPID 4682
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Error_Temp_Off'
			/TreeUPID 4683
			/Type 'DOUBLE'
		] 				
		% TEMPERATURE MONITORING END
		
		% EXTENSION CABLE BEGIN		
		[D
			/Name 'Ext_Cable_Resistance'
			/CaptionKeyWord 'Ext_Cable_Resistance'
			/TreeUPID 4518
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'		
		]		
		% CABLE1 BEGIN
		[D
			/Name 'Cable1_Type'
			/TreeUPID 6230
			/DefValue 0
			/StartWithTreeValue #1   
			/Type 'ENUM'
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Cable'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.0 ] 
					]
				]																											
				[D
					/Value 2
					/Caption 'K05'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 3
					/Caption 'K15'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.012 ] 
					]
				]																											
				[D
					/Value 6
					/Caption 'KS03'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.053 ] 
					]
				]																											
				[D
					/Value 4
					/Caption 'KS05'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 5
					/Caption 'KS10'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Generic_Cable'					
					/OnSelect [A 
						%[D /Name 'Cable1_Section' /Value 0 ]
					]  
				]																											
			]				
		]	
		
		[D
			/Name 'Cable1_Section'
			/TreeUPID 6231
			/DefValue 0
			/StartWithTreeValue #1
			/Type 'ENUM'								
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/Caption '0.34 mm^2 / AWG 22'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.053 ] 
					]
				]																											
				[D
					/Value 1
					/Caption '0.5 mm^2 / AWG 20'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 2
					/Caption '0.75 mm^2 / AWG 19'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.024 ] 
					]
				]																											
				[D
					/Value 3
					/Caption '1.0 mm^2 / AWG 18'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 4
					/Caption '1.5 mm^2 / AWG 16'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.012 ] 
					]
				]																											
			]	
		]	
		
		[D
			/Name 'Cable1_Length'
			/TreeUPID 6232
			/DefValue 0.0
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/Type 'DOUBLE'								
		]
		% CABLE1 END
		
		% CABLE2 BEGIN
		[D
			/Name 'Cable2_Type'
			/TreeUPID 6233
			/DefValue 0
			/StartWithTreeValue #1   		
			/Type 'ENUM'
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Cable'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.0 ] 
					]
				]																											
				[D
					/Value 2
					/Caption 'K05'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 3
					/Caption 'K15'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.012 ] 
					]
				]																											
				[D
					/Value 6
					/Caption 'KS03'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.053 ] 
					]
				]																											
				[D
					/Value 4
					/Caption 'KS05'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 5
					/Caption 'KS10'					
					/ShowWithCompanyPrefix #1					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Generic_Cable'					
					/OnSelect [A 
						%[D /Name 'Cable2_Section' /Value 0 ]
					]  
				]																											
			]				
		]	
		[D
			/Name 'Cable2_Section'
			/TreeUPID 6234
			/DefValue 0
			/StartWithTreeValue #1
			/Type 'ENUM'								
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/Caption '0.34 mm^2 / AWG 22'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.053 ] 
					]
				]																											
				[D
					/Value 1
					/Caption '0.5 mm^2 / AWG 20'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 2
					/Caption '0.75 mm^2 / AWG 19'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.024 ] 
					]
				]																											
				[D
					/Value 3
					/Caption '1.0 mm^2 / AWG 18'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 4
					/Caption '1.5 mm^2 / AWG 16'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.012 ] 
					]
				]																											
			]	
		]	
		[D
			/Name 'Cable2_Length'
			/TreeUPID 6235
			/DefValue 0.0
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/Type 'DOUBLE'								
		]
		% CABLE2 END
	]	
	
]   
